/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.caret.service.ctssh.response;

import gov.va.caret.service.ctssh.request.Request;
import gov.va.caret.service.ctssh.template.ParameterValidationResult;

/**
 *
 * @author ronaday
 */
public class Response {
	
    /**
     * 
     */
    private String _key = null;
    /**
     * 
     */
    private ParameterValidationResult _vresult = null;
    /**
     * 
     */
    private String _fail_message = null;
    /**
     * 
     */
    private Exception _fail_exception = null;
    /**
     * 
     */
    private boolean _err = false;
    
    /**
     * @param req
     */
    public Response(Request req)
    {
        _key = req.key();
    }
        
    /**
     * @param key
     */
    public Response(String key) {
    	_key = key;
	}

	/**
	 * @return
	 */
	public String key()
    {
        return _key;
    }

    /**
     * @return
     */
    public boolean error()
    {
    	return _err;
    }

	/**
	 * @param vresult
	 */
	public void setValidationResult(ParameterValidationResult vresult) {
		
		_vresult = vresult;
		if(_vresult.valid() == false)
		{
			_err = true;
			_fail_message = "Invalid Parameters";
		}
		
	}

	/**
	 * @param e
	 */
	public void setError(Exception e) {
		_fail_exception = e;
		//_emessage = e.getMessage();
		_err = true;
	}

	/**
	 * @param failmsg
	 */
	public void setErrorMessage(String failmsg) {
		_fail_message = failmsg;
	}
    
	/**
	 * @return
	 */
	public String errormsg()
	{
		return _fail_message;
	}
	  
	/**
	 * @return
	 */
	public Exception exception()
	{
		return _fail_exception;
	}



	/**
	 * @param resp
	 * @throws Exception
	 */
	public void addResponse(Response resp) throws Exception {
		throw new Exception("addResponse must be overridden!");
		
	}

	/**
	 * @return
	 * @throws Exception
	 */
	public String report() throws Exception {

		throw new Exception("report() must be overridden!");
	}
	    
	/**
	 * @param key
	 * @return
	 * @throws Exception
	 */
	public String report(String key) throws Exception {

		throw new Exception("report(key) must be overridden!");
		
	}
	
	
	public String toHMTL() throws Exception {
		return "<html/>";
	}
	   	
}
